@extends('layouts.app')

@section('content')
<div class="container mt-5">
    <div class="row">
        <div class="col-md-12">

            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <h4>Restaurant List</h4>
                    <a href="{{ route('restaurants.create') }}" class="btn btn-light btn-sm">Add Restaurant</a>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif

                    @if(isset($restaurants) && $restaurants->count() > 0)
                        <table class="table table-bordered table-striped">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Address</th>
                                    <th>Website</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($restaurants as $restaurant)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $restaurant->user->name ?? '-' }}</td>
                                        <td>{{ $restaurant->user->email ?? '-' }}</td>
                                        <td>{{ $restaurant->address ?? '-' }}</td>
                                        <td>{{ $restaurant->website ?? '-' }}</td>
                                        <td>{{ $restaurant->created_at->format('d M Y') }}</td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="actionDropdown{{ $restaurant->id }}" data-bs-toggle="dropdown" aria-expanded="false">
                                                    Actions
                                                </button>
                                                <ul class="dropdown-menu" aria-labelledby="actionDropdown{{ $restaurant->id }}">
                                                    <li>
                                                        <a class="dropdown-item" href="{{ route('restaurants.edit', $restaurant->id) }}">Edit</a>
                                                    </li>
                                                    <li>
                                                        <form action="{{ route('restaurants.destroy', $restaurant->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this restaurant?');">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button class="dropdown-item text-danger" type="submit">Delete</button>
                                                        </form>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <p class="text-center">No restaurants found!</p>
                    @endif
                </div>
            </div>

        </div>
    </div>
</div>
@endsection
